#ifndef KERNEL_LIST
#define KERNEL_LIST

#include "gauss_3x3_acf.h"
#include "fast9_acf.h"
#include "nms_acf.h"
#include "dilate_diamond_acf.h"
#include "cvt_16low_to_8_acf.h"
#include "add_acf.h"

KERNEL_INFO kernelInfoConcat(GAUSS_3x3_K)(
	"apu_gauss_3x3", 2,
	   __port(__index(0),
	   __identifier(GAUSS_3x3_KN_IN),
	          __attributes(ACF_ATTR_VEC_IN),
	          __spatial_dep(1,1,1,1),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1)),
	   __port(__index(1),
	   __identifier(GAUSS_3x3_KN_OUT),
	          __attributes(ACF_ATTR_VEC_OUT),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1))
	);

KERNEL_INFO kernelInfoConcat(FAST9_K)(
	"apu_fast9", 3,
		__port(__index(0),
			__identifier(FAST9_KN_IN_IMG),
			__attributes(ACF_ATTR_VEC_IN),
			__spatial_dep(3, 3, 3, 3),
			__e0_data_type(d08u),
			__e0_size(1, 1),
			__ek_size(1, 1)),
		__port(__index(1),
			__identifier(FAST9_KN_OUT),
			__attributes(ACF_ATTR_VEC_OUT),
			__spatial_dep(0, 0, 0, 0),
			__e0_data_type(d08u),
			__e0_size(1, 1),
			__ek_size(1, 1)),
		__port(__index(2),
			__identifier(FAST9_KN_IN_THR),
			__attributes(ACF_ATTR_SCL_IN_STATIC_FIXED),
			__spatial_dep(0, 0, 0, 0),
			__e0_data_type(d08u),
			__e0_size(1, 1),
			__ek_size(1, 1))
	);

KERNEL_INFO kernelInfoConcat(NMS_K)(
	"apu_nms", 2,
	   __port(__index(0),
	          __identifier(NMS16_KN_IN),
	          __attributes(ACF_ATTR_VEC_IN),
	          __spatial_dep(1,1,1,1),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1)),
	   __port(__index(1),
	          __identifier(NMS16_KN_OUT),
	          __attributes(ACF_ATTR_VEC_OUT),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1))
	);


KERNEL_INFO kernelInfoConcat(DILATE_DIAMOND_K)(
	"apu_dilate_diamond", 2,
	   __port(__index(0),
	          __identifier(DILATE_DIAMOND_KN_IN),
	          __attributes(ACF_ATTR_VEC_IN),
	          __spatial_dep(2,2,2,2),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1)),
	   __port(__index(1),
	          __identifier(DILATE_DIAMOND_KN_OUT),
	          __attributes(ACF_ATTR_VEC_OUT),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1))
	);

KERNEL_INFO kernelInfoConcat(_16_LOW_TO_8_K)(
	"apu_16low_to_8", 2,
	   __port(__index(0),
	          __identifier(_16_LOW_TO_8_KN_IN),
	          __attributes(ACF_ATTR_VEC_IN),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d16u),
	          __e0_size(1, 1),
	          __ek_size(1, 1)),
	   __port(__index(1),
	          __identifier(_16_LOW_TO_8_KN_OUT),
	          __attributes(ACF_ATTR_VEC_OUT),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1))
	);

KERNEL_INFO kernelInfoConcat(ADD_K)(
	"apu_add", 3,
	   __port(__index(0),
	          __identifier(ADD_KN_INA),
	          __attributes(ACF_ATTR_VEC_IN),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1)),
	   __port(__index(1),
	          __identifier(ADD_KN_INB),
	          __attributes(ACF_ATTR_VEC_IN),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d08u),
	          __e0_size(1, 1),
	          __ek_size(1, 1)),
	   __port(__index(2),
	          __identifier(ADD_KN_OUT),
	          __attributes(ACF_ATTR_VEC_OUT),
	          __spatial_dep(0,0,0,0),
	          __e0_data_type(d16u),
	          __e0_size(1, 1),
	          __ek_size(1, 1))
	);

#endif
